using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

using System.IO;

namespace BlobAccess
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.DataGrid dataGrid1;
		private System.Windows.Forms.PictureBox pictureBox1;
		private Borland.Data.Provider.BdpConnection bdpConnection1;
		private Borland.Data.Provider.BdpDataAdapter bdpDataAdapter1;
		private Borland.Data.Provider.BdpCommand bdpSelectCommand1;
		private Borland.Data.Provider.BdpCommand bdpInsertCommand1;
		private Borland.Data.Provider.BdpCommand bdpUpdateCommand1;
		private Borland.Data.Provider.BdpCommand bdpDeleteCommand1;
		private System.Data.DataSet dataSet1;
		private System.Data.DataTable dataTable1;
		private System.Data.DataColumn dataColumn1;
		private System.Data.DataColumn dataColumn2;
		private System.Data.DataColumn dataColumn3;
		private System.Data.DataColumn dataColumn4;
		private System.Data.DataColumn dataColumn5;
		private System.Data.DataColumn dataColumn6;

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.dataGrid1 = new System.Windows.Forms.DataGrid();
			this.dataSet1 = new System.Data.DataSet();
			this.dataTable1 = new System.Data.DataTable();
			this.dataColumn1 = new System.Data.DataColumn();
			this.dataColumn2 = new System.Data.DataColumn();
			this.dataColumn3 = new System.Data.DataColumn();
			this.dataColumn4 = new System.Data.DataColumn();
			this.dataColumn5 = new System.Data.DataColumn();
			this.dataColumn6 = new System.Data.DataColumn();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.bdpConnection1 = new Borland.Data.Provider.BdpConnection();
			this.bdpDataAdapter1 = new Borland.Data.Provider.BdpDataAdapter();
			this.bdpDeleteCommand1 = new Borland.Data.Provider.BdpCommand();
			this.bdpInsertCommand1 = new Borland.Data.Provider.BdpCommand();
			this.bdpSelectCommand1 = new Borland.Data.Provider.BdpCommand();
			this.bdpUpdateCommand1 = new Borland.Data.Provider.BdpCommand();
			((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.dataSet1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.dataTable1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.bdpDataAdapter1)).BeginInit();
			this.SuspendLayout();
			// 
			// dataGrid1
			// 
			this.dataGrid1.AllowSorting = false;
			this.dataGrid1.AlternatingBackColor = System.Drawing.Color.LightGray;
			this.dataGrid1.BackColor = System.Drawing.Color.DarkGray;
			this.dataGrid1.CaptionBackColor = System.Drawing.Color.White;
			this.dataGrid1.CaptionFont = new System.Drawing.Font("Verdana", 10F);
			this.dataGrid1.CaptionForeColor = System.Drawing.Color.Navy;
			this.dataGrid1.CaptionText = "Travel Log";
			this.dataGrid1.DataMember = "TRAVELLOG";
			this.dataGrid1.DataSource = this.dataSet1;
			this.dataGrid1.Dock = System.Windows.Forms.DockStyle.Top;
			this.dataGrid1.ForeColor = System.Drawing.Color.Black;
			this.dataGrid1.GridLineColor = System.Drawing.Color.Black;
			this.dataGrid1.GridLineStyle = System.Windows.Forms.DataGridLineStyle.None;
			this.dataGrid1.HeaderBackColor = System.Drawing.Color.Silver;
			this.dataGrid1.HeaderForeColor = System.Drawing.Color.Black;
			this.dataGrid1.LinkColor = System.Drawing.Color.Navy;
			this.dataGrid1.Location = new System.Drawing.Point(0, 0);
			this.dataGrid1.Name = "dataGrid1";
			this.dataGrid1.ParentRowsBackColor = System.Drawing.Color.White;
			this.dataGrid1.ParentRowsForeColor = System.Drawing.Color.Black;
			this.dataGrid1.SelectionBackColor = System.Drawing.Color.Navy;
			this.dataGrid1.SelectionForeColor = System.Drawing.Color.White;
			this.dataGrid1.Size = new System.Drawing.Size(704, 280);
			this.dataGrid1.TabIndex = 0;
			this.dataGrid1.CurrentCellChanged += new System.EventHandler(this.dataGrid1_CurrentCellChanged);
			// 
			// dataSet1
			// 
			this.dataSet1.DataSetName = "NewDataSet";
			this.dataSet1.Locale = new System.Globalization.CultureInfo("en-US");
			this.dataSet1.Tables.AddRange(new System.Data.DataTable[] {
						this.dataTable1});
			// 
			// dataTable1
			// 
			this.dataTable1.Columns.AddRange(new System.Data.DataColumn[] {
						this.dataColumn1,
						this.dataColumn2,
						this.dataColumn3,
						this.dataColumn4,
						this.dataColumn5,
						this.dataColumn6});
			this.dataTable1.TableName = "TRAVELLOG";
			// 
			// dataColumn1
			// 
			this.dataColumn1.ColumnName = "PICTNO";
			this.dataColumn1.DataType = typeof(int);
			// 
			// dataColumn2
			// 
			this.dataColumn2.ColumnName = "YEARTAKEN";
			this.dataColumn2.DataType = typeof(int);
			// 
			// dataColumn3
			// 
			this.dataColumn3.ColumnName = "DESCRIPTION";
			this.dataColumn3.MaxLength = 31;
			// 
			// dataColumn4
			// 
			this.dataColumn4.ColumnName = "BMP";
			this.dataColumn4.DataType = typeof(byte[]);
			// 
			// dataColumn5
			// 
			this.dataColumn5.ColumnName = "NOTES";
			this.dataColumn5.DataType = typeof(char[]);
			// 
			// dataColumn6
			// 
			this.dataColumn6.ColumnName = "COUNTRY";
			this.dataColumn6.MaxLength = 25;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.pictureBox1.Location = new System.Drawing.Point(0, 286);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(704, 360);
			this.pictureBox1.TabIndex = 1;
			this.pictureBox1.TabStop = false;
			// 
			// bdpConnection1
			// 
			this.bdpConnection1.ConnectionOptions = "waitonlocks=False;commitretain=False;sqldialect=3;transaction isol" +  
				"ation=ReadCommitted;servercharset=;rolename=myrole";
			this.bdpConnection1.ConnectionString = @"database=C:\\Program Files\\Borland\\BDS\\4.0\\Demos\\Delphi.Net\\DBWeb\\WorldTravel\\WorldTravel.gdb;assembly=Borland.Data.Interbase, Version=2.5.0.0, Culture=neutral, PublicKeyToken=91d62ebb5b0d1b1b;vendorclient=gds32.dll;provider=Interbase;username=sysdba;password=masterkey";
			// 
			// bdpDataAdapter1
			// 
			this.bdpDataAdapter1.Active = true;
			this.bdpDataAdapter1.DataSet = this.dataSet1;
			this.bdpDataAdapter1.DataTable = this.dataTable1;
			this.bdpDataAdapter1.DeleteCommand = this.bdpDeleteCommand1;
			this.bdpDataAdapter1.InsertCommand = this.bdpInsertCommand1;
			this.bdpDataAdapter1.SelectCommand = this.bdpSelectCommand1;
			this.bdpDataAdapter1.StartRecord = 0;
			this.bdpDataAdapter1.TableMappings.AddRange(new System.Data.Common.DataTableMapping[] {
						new System.Data.Common.DataTableMapping("Table", "TRAVELLOG", new System.Data.Common.DataColumnMapping[] {
									new System.Data.Common.DataColumnMapping("PICTNO", "PICTNO"),
									new System.Data.Common.DataColumnMapping("YEARTAKEN", "YEARTAKEN"),
									new System.Data.Common.DataColumnMapping("DESCRIPTION", "DESCRIPTION"),
									new System.Data.Common.DataColumnMapping("BMP", "BMP"),
									new System.Data.Common.DataColumnMapping("NOTES", "NOTES"),
									new System.Data.Common.DataColumnMapping("COUNTRY", "COUNTRY")})});
			this.bdpDataAdapter1.UpdateCommand = this.bdpUpdateCommand1;
			// 
			// bdpDeleteCommand1
			// 
			this.bdpDeleteCommand1.CommandOptions = null;
			this.bdpDeleteCommand1.CommandText = "DELETE FROM TRAVELLOG WHERE PICTNO = ? AND YEARTAKEN = ? AND DESCR" +  
				"IPTION = ? AND COUNTRY = ?";
			this.bdpDeleteCommand1.CommandType = System.Data.CommandType.Text;
			this.bdpDeleteCommand1.Connection = this.bdpConnection1;
			this.bdpDeleteCommand1.ParameterCount = ((short)(4));
			this.bdpDeleteCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("PICTNOOriginal", Borland.Data.Common.BdpType.Int32, Borland.Data.Common.BdpType.Unknown, 4, System.Data.ParameterDirection.Input, false, ((byte)(4)), ((byte)(0)), 4, "PICTNO", System.Data.DataRowVersion.Original, null));
			this.bdpDeleteCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("YEARTAKENOriginal", Borland.Data.Common.BdpType.Int32, Borland.Data.Common.BdpType.Unknown, 4, System.Data.ParameterDirection.Input, false, ((byte)(4)), ((byte)(0)), 4, "YEARTAKEN", System.Data.DataRowVersion.Original, null));
			this.bdpDeleteCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("DESCRIPTIONOriginal", Borland.Data.Common.BdpType.String, Borland.Data.Common.BdpType.Unknown, 31, System.Data.ParameterDirection.Input, false, ((byte)(30)), ((byte)(0)), 30, "DESCRIPTION", System.Data.DataRowVersion.Original, null));
			this.bdpDeleteCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("COUNTRYOriginal", Borland.Data.Common.BdpType.String, Borland.Data.Common.BdpType.Unknown, 25, System.Data.ParameterDirection.Input, false, ((byte)(24)), ((byte)(0)), 24, "COUNTRY", System.Data.DataRowVersion.Original, null));
			this.bdpDeleteCommand1.SchemaName = null;
			this.bdpDeleteCommand1.Transaction = null;
			this.bdpDeleteCommand1.UpdatedRowSource = System.Data.UpdateRowSource.None;
			// 
			// bdpInsertCommand1
			// 
			this.bdpInsertCommand1.CommandOptions = null;
			this.bdpInsertCommand1.CommandText = "INSERT INTO TRAVELLOG (PICTNO, YEARTAKEN, DESCRIPTION, BMP, NOTES," +  
				" COUNTRY ) VALUES ( ?, ?, ?, ?, ?, ?)";
			this.bdpInsertCommand1.CommandType = System.Data.CommandType.Text;
			this.bdpInsertCommand1.Connection = this.bdpConnection1;
			this.bdpInsertCommand1.ParameterCount = ((short)(6));
			this.bdpInsertCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("PICTNO", Borland.Data.Common.BdpType.Int32, Borland.Data.Common.BdpType.Unknown, 4, System.Data.ParameterDirection.Input, false, ((byte)(4)), ((byte)(0)), 4, "PICTNO", System.Data.DataRowVersion.Current, null));
			this.bdpInsertCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("YEARTAKEN", Borland.Data.Common.BdpType.Int32, Borland.Data.Common.BdpType.Unknown, 4, System.Data.ParameterDirection.Input, false, ((byte)(4)), ((byte)(0)), 4, "YEARTAKEN", System.Data.DataRowVersion.Current, null));
			this.bdpInsertCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("DESCRIPTION", Borland.Data.Common.BdpType.String, Borland.Data.Common.BdpType.Unknown, 31, System.Data.ParameterDirection.Input, false, ((byte)(30)), ((byte)(0)), 30, "DESCRIPTION", System.Data.DataRowVersion.Current, null));
			this.bdpInsertCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("BMP", Borland.Data.Common.BdpType.Blob, Borland.Data.Common.BdpType.stBinary, 8, System.Data.ParameterDirection.Input, false, ((byte)(8)), ((byte)(0)), 8, "BMP", System.Data.DataRowVersion.Current, null));
			this.bdpInsertCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("NOTES", Borland.Data.Common.BdpType.Blob, Borland.Data.Common.BdpType.stMemo, 8, System.Data.ParameterDirection.Input, false, ((byte)(8)), ((byte)(0)), 8, "NOTES", System.Data.DataRowVersion.Current, null));
			this.bdpInsertCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("COUNTRY", Borland.Data.Common.BdpType.String, Borland.Data.Common.BdpType.Unknown, 25, System.Data.ParameterDirection.Input, false, ((byte)(24)), ((byte)(0)), 24, "COUNTRY", System.Data.DataRowVersion.Current, null));
			this.bdpInsertCommand1.SchemaName = null;
			this.bdpInsertCommand1.Transaction = null;
			this.bdpInsertCommand1.UpdatedRowSource = System.Data.UpdateRowSource.None;
			// 
			// bdpSelectCommand1
			// 
			this.bdpSelectCommand1.CommandOptions = null;
			this.bdpSelectCommand1.CommandText = "SELECT * FROM TRAVELLOG";
			this.bdpSelectCommand1.CommandType = System.Data.CommandType.Text;
			this.bdpSelectCommand1.Connection = this.bdpConnection1;
			this.bdpSelectCommand1.ParameterCount = ((short)(0));
			this.bdpSelectCommand1.SchemaName = null;
			this.bdpSelectCommand1.Transaction = null;
			this.bdpSelectCommand1.UpdatedRowSource = System.Data.UpdateRowSource.None;
			// 
			// bdpUpdateCommand1
			// 
			this.bdpUpdateCommand1.CommandOptions = null;
			this.bdpUpdateCommand1.CommandText = "UPDATE TRAVELLOG SET PICTNO = ?, YEARTAKEN = ?, DESCRIPTION = ?, B" +  
				"MP = ?, NOTES = ?, COUNTRY = ? WHERE PICTNO = ? AND YEARTAKEN = ?" +  
				" AND DESCRIPTION = ? AND COUNTRY = ?";
			this.bdpUpdateCommand1.CommandType = System.Data.CommandType.Text;
			this.bdpUpdateCommand1.Connection = this.bdpConnection1;
			this.bdpUpdateCommand1.ParameterCount = ((short)(10));
			this.bdpUpdateCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("PICTNO", Borland.Data.Common.BdpType.Int32, Borland.Data.Common.BdpType.Unknown, 4, System.Data.ParameterDirection.Input, false, ((byte)(4)), ((byte)(0)), 4, "PICTNO", System.Data.DataRowVersion.Current, null));
			this.bdpUpdateCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("YEARTAKEN", Borland.Data.Common.BdpType.Int32, Borland.Data.Common.BdpType.Unknown, 4, System.Data.ParameterDirection.Input, false, ((byte)(4)), ((byte)(0)), 4, "YEARTAKEN", System.Data.DataRowVersion.Current, null));
			this.bdpUpdateCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("DESCRIPTION", Borland.Data.Common.BdpType.String, Borland.Data.Common.BdpType.Unknown, 31, System.Data.ParameterDirection.Input, false, ((byte)(30)), ((byte)(0)), 30, "DESCRIPTION", System.Data.DataRowVersion.Current, null));
			this.bdpUpdateCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("BMP", Borland.Data.Common.BdpType.Blob, Borland.Data.Common.BdpType.stBinary, 8, System.Data.ParameterDirection.Input, false, ((byte)(8)), ((byte)(0)), 8, "BMP", System.Data.DataRowVersion.Current, null));
			this.bdpUpdateCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("NOTES", Borland.Data.Common.BdpType.Blob, Borland.Data.Common.BdpType.stMemo, 8, System.Data.ParameterDirection.Input, false, ((byte)(8)), ((byte)(0)), 8, "NOTES", System.Data.DataRowVersion.Current, null));
			this.bdpUpdateCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("COUNTRY", Borland.Data.Common.BdpType.String, Borland.Data.Common.BdpType.Unknown, 25, System.Data.ParameterDirection.Input, false, ((byte)(24)), ((byte)(0)), 24, "COUNTRY", System.Data.DataRowVersion.Current, null));
			this.bdpUpdateCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("PICTNOOriginal", Borland.Data.Common.BdpType.Int32, Borland.Data.Common.BdpType.Unknown, 4, System.Data.ParameterDirection.Input, false, ((byte)(4)), ((byte)(0)), 4, "PICTNO", System.Data.DataRowVersion.Original, null));
			this.bdpUpdateCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("YEARTAKENOriginal", Borland.Data.Common.BdpType.Int32, Borland.Data.Common.BdpType.Unknown, 4, System.Data.ParameterDirection.Input, false, ((byte)(4)), ((byte)(0)), 4, "YEARTAKEN", System.Data.DataRowVersion.Original, null));
			this.bdpUpdateCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("DESCRIPTIONOriginal", Borland.Data.Common.BdpType.String, Borland.Data.Common.BdpType.Unknown, 31, System.Data.ParameterDirection.Input, false, ((byte)(30)), ((byte)(0)), 30, "DESCRIPTION", System.Data.DataRowVersion.Original, null));
			this.bdpUpdateCommand1.Parameters.Add(new Borland.Data.Common.BdpParameter("COUNTRYOriginal", Borland.Data.Common.BdpType.String, Borland.Data.Common.BdpType.Unknown, 25, System.Data.ParameterDirection.Input, false, ((byte)(24)), ((byte)(0)), 24, "COUNTRY", System.Data.DataRowVersion.Original, null));
			this.bdpUpdateCommand1.SchemaName = null;
			this.bdpUpdateCommand1.Transaction = null;
			this.bdpUpdateCommand1.UpdatedRowSource = System.Data.UpdateRowSource.None;
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(704, 646);
			this.Controls.Add(this.pictureBox1);
			this.Controls.Add(this.dataGrid1);
			this.Name = "WinForm";
			this.Text = "Blob Access Demo";
			this.Load += new System.EventHandler(this.WinForm_Load);
			((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.dataSet1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.dataTable1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.bdpDataAdapter1)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new WinForm());
		}

		private void dataGrid1_CurrentCellChanged(object sender, System.EventArgs e)
		{
			UpdateMedia();
		}

		private byte[] b_image;
		//private char[] c_memo;
		private void UpdateMedia(){

			if ( dataGrid1.CurrentRowIndex < dataSet1.Tables["TravelLog"].Rows.Count)
				b_image = GetImage( dataSet1.Tables["TravelLog"].Rows[ dataGrid1.CurrentRowIndex ] );
			//c_memo = GetMemo( dataSet1.Tables["TravelLog"].Rows[ dataGrid1.CurrentRowIndex ] );

			if( b_image != null )
				pictureBox1.Image = Image.FromStream(( new MemoryStream( b_image, false ) ));

			//if( c_memo != null )
				//textBox1.Text = new String(c_memo);


		}

		protected byte[] GetImage( DataRow row )
		{
			if( row != null )
			{
				if( ! row.IsNull("BMP") )
				{
					Byte[] byteBlobData = new Byte[0];
					try
					{
					byteBlobData = (Byte[])row["BMP"];
					return byteBlobData;
					}
					catch
					{
						return null;
					}
				}
			}
			return null;
		}

		protected char[] GetMemo( DataRow row )
		{
			if( row != null )
			{
				if( ! row.IsNull("NOTES") )
				{
					char[] charBlobData = new char[0];
					try
					{
					charBlobData = (char[])row["NOTES"];
					return charBlobData;
					}
					catch
					{
						return null;
					}
				}
			}
			return null;
		}
		
		private void WinForm_Load(object sender, System.EventArgs e)
		{
            UpdateMedia();
		}

	}
}
